(function($) {
	function init(_470) {
		$(_470).addClass("validatebox-text");
	}
	;
	function _471(_472) {
		var _473 = $.data(_472, "validatebox");
		_473.validating = false;
		if (_473.timer) {
			clearTimeout(_473.timer);
		}
		$(_472).tooltip("destroy");
		$(_472).unbind();
		$(_472).remove();
	}
	;
	function _474(_475) {
		var opts = $.data(_475, "validatebox").options;
		var box = $(_475);
		box.unbind(".validatebox");
		if (opts.novalidate || box.is(":disabled")) {
			return;
		}
		for ( var _476 in opts.events) {
			$(_475).bind(_476 + ".validatebox", {
				target : _475
			}, opts.events[_476]);
		}
	}
	;
	function _477(e) {
		var _478 = e.data.target;
		var _479 = $.data(_478, "validatebox");
		var box = $(_478);
		if ($(_478).attr("readonly")) {
			return;
		}
		_479.validating = true;
		_479.value = undefined;
		(function() {
			if (_479.validating) {
				if (_479.value != box.val()) {
					_479.value = box.val();
					if (_479.timer) {
						clearTimeout(_479.timer);
					}
					_479.timer = setTimeout(function() {
						$(_478).validatebox("validate");
					}, _479.options.delay);
				} else {
					_47a(_478);
				}
				setTimeout(arguments.callee, 200);
			}
		})();
	}
	;
	function _47b(e) {
		var _47c = e.data.target;
		var _47d = $.data(_47c, "validatebox");
		if (_47d.timer) {
			clearTimeout(_47d.timer);
			_47d.timer = undefined;
		}
		_47d.validating = false;
		_47e(_47c);
	}
	;
	function _47f(e) {
		var _480 = e.data.target;
		if ($(_480).hasClass("validatebox-invalid")) {
			_481(_480);
		}
	}
	;
	function _482(e) {
		var _483 = e.data.target;
		var _484 = $.data(_483, "validatebox");
		if (!_484.validating) {
			_47e(_483);
		}
	}
	;
	function _481(_485) {
		var _486 = $.data(_485, "validatebox");
		var opts = _486.options;
		$(_485).tooltip($.extend({}, opts.tipOptions, {
			content : _486.message,
			position : opts.tipPosition,
			deltaX : opts.deltaX
		})).tooltip("show");
		_486.tip = true;
	}
	;
	function _47a(_487) {
		var _488 = $.data(_487, "validatebox");
		if (_488 && _488.tip) {
			$(_487).tooltip("reposition");
		}
	}
	;
	function _47e(_489) {
		var _48a = $.data(_489, "validatebox");
		_48a.tip = false;
		$(_489).tooltip("hide");
	}
	;
	function _48b(_48c) {
		var _48d = $.data(_48c, "validatebox");
		var opts = _48d.options;
		var box = $(_48c);
		opts.onBeforeValidate.call(_48c);
		var _48e = _48f();
		opts.onValidate.call(_48c, _48e);
		return _48e;
		function _490(msg) {
			_48d.message = msg;
		}
		;
		function _491(_492, _493) {
			var _494 = box.val();
			var _495 = /([a-zA-Z_]+)(.*)/.exec(_492);
			var rule = opts.rules[_495[1]];
			if (rule && _494) {
				var _496 = _493 || opts.validParams || eval(_495[2]);
				if (!rule["validator"].call(_48c, _494, _496)) {
					box.addClass("validatebox-invalid");
					var _497 = rule["message"];
					if (_496) {
						for ( var i = 0; i < _496.length; i++) {
							_497 = _497.replace(new RegExp("\\{" + i + "\\}",
									"g"), _496[i]);
						}
					}
					_490(opts.invalidMessage || _497);
					if (_48d.validating) {
						_481(_48c);
					}
					return false;
				}
			}
			return true;
		}
		;
		function _48f() {
			//box.removeClass("validatebox-invalid");
			//_47e(_48c);
			if (opts.novalidate || box.is(":disabled")) {
				return true;
			}
			if (opts.required) {
				if (box.val() == "") {
					box.addClass("validatebox-invalid");
					_490(opts.missingMessage);
					if (_48d.validating) {
						_481(_48c);
					}
					return false;
				}
			}
			if (opts.validType) {
				if ($.isArray(opts.validType)) {
					for ( var i = 0; i < opts.validType.length; i++) {
						if (!_491(opts.validType[i])) {
							return false;
						}
					}
				} else {
					if (typeof opts.validType == "string") {
						if (!_491(opts.validType)) {
							return false;
						}
					} else {
						for ( var _498 in opts.validType) {
							var _499 = opts.validType[_498];
							if (!_491(_498, _499)) {
								return false;
							}
						}
					}
				}
			}
			return true;
		}
		;
	}
	;
	function _49a(_49b, _49c) {
		var opts = $.data(_49b, "validatebox").options;
		if (_49c != undefined) {
			opts.novalidate = _49c;
		}
		if (opts.novalidate) {
			$(_49b).removeClass("validatebox-invalid");
			_47e(_49b);
		}
		_48b(_49b);
		_474(_49b);
	}
	;
	$.fn.validatebox = function(_49d, _49e) {
		if (typeof _49d == "string") {
			return $.fn.validatebox.methods[_49d](this, _49e);
		}
		_49d = _49d || {};
		return this.each(function() {
			var _49f = $.data(this, "validatebox");
			if (_49f) {
				$.extend(_49f.options, _49d);
			} else {
				init(this);
				$.data(this, "validatebox", {
					options : $.extend({}, $.fn.validatebox.defaults,
							$.fn.validatebox.parseOptions(this), _49d)
				});
			}
			_49a(this);
			_48b(this);
		});
	};
	$.fn.validatebox.methods = {
		options : function(jq) {
			return $.data(jq[0], "validatebox").options;
		},
		destroy : function(jq) {
			return jq.each(function() {
				_471(this);
			});
		},
		validate : function(jq) {
			return jq.each(function() {
				_48b(this);
			});
		},
		isValid : function(jq) {
			return _48b(jq[0]);
		},
		enableValidation : function(jq) {
			return jq.each(function() {
				_49a(this, false);
			});
		},
		disableValidation : function(jq) {
			return jq.each(function() {
				_49a(this, true);
			});
		}
	};
	$.fn.validatebox.parseOptions = function(_4a0) {
		var t = $(_4a0);
		return $.extend({}, $.parser.parseOptions(_4a0, [ "validType",
				"missingMessage", "invalidMessage", "tipPosition", {
					delay : "number",
					deltaX : "number"
				} ]), {
			required : (t.attr("required") ? true : undefined),
			novalidate : (t.attr("novalidate") != undefined ? true : undefined)
		});
	};
	$.fn.validatebox.defaults = {
		required : false,
		validType : null,
		validParams : null,
		delay : 200,
		missingMessage : "This field is required.",
		invalidMessage : null,
		tipPosition : "right",
		deltaX : 0,
		novalidate : false,
		events : {
			focus : _477,
			blur : _47b,
			mouseenter : _47f,
			click : function(e) {
				var t = $(e.data.target);
				if (!t.is(":focus")) {
					t.trigger("focus");
				}
			}
		},
		tipOptions : {
			showEvent : "none",
			hideEvent : "none",
			showDelay : 0,
			hideDelay : 0,
			zIndex : "",
			onShow : function() {
				$(this).tooltip("tip").css({
					color : "#000",
					borderColor : "#CC9933",
					backgroundColor : "#FFFFCC"
				});
			},
			onHide : function() {
				$(this).tooltip("destroy");
			}
		},
		rules : {
			email : {
				validator : function(_4a1) {
					return /^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/i
							.test(_4a1);
				},
				message : "Please enter a valid email address."
			},
			url : {
				validator : function(_4a2) {
					return /^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i
							.test(_4a2);
				},
				message : "Please enter a valid URL."
			},
			length : {
				validator : function(_4a3, _4a4) {
					var len = $.trim(_4a3).length;
					return len >= _4a4[0] && len <= _4a4[1];
				},
				message : "Please enter a value between {0} and {1}."
			},
			remote : {
				validator : function(_4a5, _4a6) {
					var data = {};
					data[_4a6[1]] = _4a5;
					var _4a7 = $.ajax({
						url : _4a6[0],
						dataType : "json",
						data : data,
						async : false,
						cache : false,
						type : "post"
					}).responseText;
					return _4a7 == "true";
				},
				message : "Please fix this field."
			}
		},
		onBeforeValidate : function() {
		},
		onValidate : function(_4a8) {
		}
	};
})(jQuery);